<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Términos y Condiciones | OrozDesign Multimedia</title>
    
    <link rel="icon" href="../oferta-web/img/favicon.webp" sizes="any">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest" defer></script>

    <link rel="stylesheet" href="../oferta-web/style.css">
    <script src="../oferta-web/script.js"></script>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'brand-primary': '#07162d',
                        'brand-secondary': '#9e1428',
                        'brand-highlight': '#ffc857',
                        'brand-light-bg': '#f5f5f5',
                        'brand-white': '#FFFFFF',
                        'brand-dark-text': '#07080a',
                        'brand-light-text': '#f3f4f6',
                    },
                    fontFamily: { 
                        'sans': ['Barlow', 'sans-serif'] 
                    }
                }
            }
        }
    </script>
</head>

<body class="font-sans bg-brand-light-bg text-brand-dark-text">

    <header class="bg-brand-primary/95 border-b border-white/10 backdrop-blur sticky top-0 z-50">
        <div class="mx-auto max-w-7xl px-4 sm:px-6">
            <div class="h-16 md:h-20 flex items-center justify-between">
                <a href="index.html" class="flex items-center gap-3" aria-label="Ir al inicio">
                    <img src="../oferta-web/img/OrozDesignMultimedia.webp" alt="Logo OrozDesign Multimedia" class="h-8 md:h-10 w-auto">
                </a>
                <a href="/" class="font-bold text-white hover:text-brand-highlight uppercase tracking-wide text-sm">
                    Volver al Inicio
                </a>
            </div>
        </div>
    </header>

    <main class="container mx-auto max-w-4xl px-6 py-16 md:py-24">
        
        <h1 class="font-black text-4xl md:text-5xl text-brand-primary uppercase">Términos y Condiciones</h1>
        <p class="mt-2 text-gray-500">Última actualización: 25 de agosto de 2025</p>
        
        <div class="mt-8 text-lg text-gray-700 leading-relaxed space-y-4">
            
            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">1. ACUERDO DE LOS TÉRMINOS</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>Estos Términos y Condiciones constituyen un acuerdo legalmente vinculante entre usted ("usted") y OrozDesign Multimedia ("nosotros", "nuestro"), con respecto a su acceso y uso del sitio web www.generamasclientes.com (el "Sitio").</p>
            <p>Usted acepta que al acceder al Sitio, ha leído, entendido y aceptado estar sujeto a todos estos Términos y Condiciones. Si no está de acuerdo con todos estos términos, tiene prohibido usar el Sitio y debe discontinuar su uso inmediatamente.</p>

            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">2. PROPIEDAD INTELECTUAL</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>El Sitio es de nuestra propiedad y todo el contenido, incluyendo código fuente, diseños, texto, fotografías y gráficos (el "Contenido") y las marcas comerciales y logotipos (las "Marcas") son de nuestra propiedad y están protegidos por las leyes de derechos de autor y marcas registradas.</p>

            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">3. PRODUCTOS Y SERVICIOS</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>Hacemos todo lo posible para mostrar con la mayor precisión posible los detalles de los servicios disponibles en el Sitio. Nos reservamos el derecho de discontinuar cualquier servicio en cualquier momento. Los precios están sujetos a cambios.</p>
            
            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">4. PAGOS Y POLÍTICA DE REEMBOLSO</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>Aceptamos pagos a través de Visa, Mastercard, American Express y PayPal. Usted se compromete a proporcionar información de compra y de cuenta actual, completa y precisa.</p>
            <p>Todos los pagos se realizarán en dólares estadounidenses (USD). Usted acepta pagar todos los cargos a los precios vigentes en el momento de su compra.</p>
            
            <p class="font-bold bg-brand-highlight/20 p-4 border border-brand-highlight/70 rounded-lg">
                Todas las ventas son finales. Debido a la naturaleza de nuestros servicios digitales y personalizados, no se emitirá ningún reembolso bajo ninguna circunstancia una vez que se haya realizado el pago.
            </p>
            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">5. ACTIVIDADES PROHIBIDAS</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>No puede acceder ni utilizar el Sitio para ningún propósito que no sea aquel para el que lo ponemos a disposición. El uso comercial del Sitio está prohibido a menos que sea aprobado explícitamente por nosotros.</p>
            
            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">6. LEY APLICABLE</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>Estos Términos y Condiciones se regirán e interpretarán de acuerdo con las leyes de la jurisdicción donde OrozDesign Multimedia tiene su sede principal de negocios. Las partes se someten irrevocablemente a la jurisdicción exclusiva de los tribunales de dicha ubicación para la resolución de cualquier disputa.</p>
            
            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">7. LIMITACIÓN DE RESPONSABILIDAD</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>EN NINGÚN CASO NOSOTROS O NUESTROS DIRECTORES O EMPLEADOS SEREMOS RESPONSABLES ANTE USTED O CUALQUIER TERCERO POR DAÑOS DIRECTOS, INDIRECTOS, CONSECUENTES, INCIDENTALES O PUNITIVOS DERIVADOS DE SU USO DEL SITIO, INCLUSO SI HEMOS SIDO ADVERTIDOS DE LA POSIBILIDAD DE DICHOS DAÑOS.</p>

            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">8. CONTACTO</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>Para resolver una queja sobre el Sitio o para recibir más información, por favor contáctenos en:</p>
            <div class="mt-4 bg-brand-primary/5 border border-brand-primary/20 p-6 rounded-lg">
                <ul class="list-none space-y-2 text-brand-dark-text">
                    <li class="font-black text-xl">OrozDesign Multimedia</li>
                    <li>14 Avenida 17-20 Zona 10, Guatemala City, Guatemala, 01010</li>
                    <li><a href="mailto:info@orozdesign.com" class="font-bold hover:text-brand-secondary">info@orozdesign.com</a></li>
                    <li><a href="tel:+14257772109" class="font-bold hover:text-brand-secondary">+1.425.777.2109</a></li>
                </ul>
            </div>
        </div>
    </main>

    <footer class="bg-dark-black-bg text-white/70 py-8">
        <div class="container mx-auto max-w-7xl px-6 text-center text-sm">
            © <span id="year"></span> <b>OrozDesign Multimedia.</b> Todos los derechos reservados.
        </div>
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
            const yearEl = document.getElementById('year');
            if (yearEl) {
                yearEl.textContent = new Date().getFullYear();
            }
        });
    </script>

</body>
</html>