<?php
header('Content-Type: application/json');

function isSpamEmail($email, $honeypot) {
    if (!empty($honeypot)) return true;

    $blocked_tlds = ['.ru', '.cn', '.xyz', '.biz', '.top', '.site', '.online', '.club', '.cyou'];
    $disposable_domains = ['mailinator.com', '10minutemail.com', 'temp-mail.org', 'guerrillamail.com'];
    
    $email_parts = explode('@', $email);
    $domain = strtolower(end($email_parts));

    foreach ($blocked_tlds as $tld) {
        if (substr($email, -strlen($tld)) === $tld) return true;
    }
    if (in_array($domain, $disposable_domains)) return true;

    return false;
}

$response = ['success' => false, 'message' => ''];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $recipient = "orozdesign@gmail.com";
    $sender_email = "no-reply@generamasclientes.com";

    $email = trim(filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL));
    $honeypot = isset($_POST['user_comment']) ? trim($_POST['user_comment']) : '';

    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response['message'] = 'Por favor, introduce una dirección de correo válida.';
    } elseif (isSpamEmail($email, $honeypot)) {
        $response['success'] = true;
        $response['message'] = '¡Gracias! Te hemos añadido a la lista de espera.';
    } else {
        $email_subject = "Nueva Suscripción a la Lista de Espera VIP";
        $email_content = "Un nuevo visitante se ha suscrito a la lista de espera.\n\nCorreo Electrónico: " . $email . "\n";
        $email_headers = "From: Notificación <" . $sender_email . ">\r\n" .
                         "Reply-To: " . $email . "\r\n" .
                         "Content-Type: text/plain; charset=UTF-8\r\n";

        if (@mail($recipient, $email_subject, $email_content, $email_headers)) {
            $response['success'] = true;
            $response['message'] = '¡Gracias! Estás en la lista. Te avisaremos primero.';
        } else {
            $response['message'] = 'Hubo un problema en el servidor. Inténtalo de nuevo.';
        }
    }
} else {
    $response['message'] = 'Método no válido.';
}

echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>