<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // --- Configuración del Correo ---
    $recipient_email = "orozdesign@gmail.com"; // Reemplaza con tu dirección de correo
    $email_subject = "Nueva Información De Cliente Para Página Web: " . htmlspecialchars($_POST['nombre_negocio']);
    $from_email = "no-reply@orozdesign.com";

    // --- Recopilación de Datos ---
    $nombre_completo = htmlspecialchars($_POST['nombre_completo']);
    $telefono_personal = htmlspecialchars($_POST['telefono_personal']);
    $email_personal = htmlspecialchars($_POST['email_personal']);
    $nombre_negocio = htmlspecialchars($_POST['nombre_negocio']);
    $telefono_negocio = htmlspecialchars($_POST['telefono_negocio']);
    $email_negocio = htmlspecialchars($_POST['email_negocio']);
    $servicios = htmlspecialchars($_POST['servicios']);
    $ciudades = htmlspecialchars($_POST['ciudades']);

    // --- Lógica para Subida de Archivos ---
    $upload_dir = 'uploads/';
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }

    $attachments = [];
    $allowed_types = ['image/jpeg', 'image/png', 'image/svg+xml', 'image/webp']; // Tipos de archivo permitidos

    // Procesar el logotipo
    if (isset($_FILES['logotipo']) && $_FILES['logotipo']['error'] == 0) {
        $file_type = mime_content_type($_FILES['logotipo']['tmp_name']);
        if (in_array($file_type, $allowed_types)) {
            $logo_path = $upload_dir . basename($_FILES['logotipo']['name']);
            if (move_uploaded_file($_FILES['logotipo']['tmp_name'], $logo_path)) {
                $attachments[] = $logo_path;
            }
        }
    }

    // Procesar las fotos de proyectos
    if (isset($_FILES['fotos'])) {
        foreach ($_FILES['fotos']['tmp_name'] as $key => $tmp_name) {
            if ($_FILES['fotos']['error'][$key] == 0) {
                $file_type = mime_content_type($tmp_name);
                if (in_array($file_type, $allowed_types)) {
                    $photo_path = $upload_dir . basename($_FILES['fotos']['name'][$key]);
                    if (move_uploaded_file($tmp_name, $photo_path)) {
                        $attachments[] = $photo_path;
                    }
                }
            }
        }
    }

    // --- Construcción del Correo ---
    $boundary = "boundary-" . md5(time());
    $headers = "From: $from_email\r\n";
    $headers .= "Reply-To: $email_personal\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: multipart/mixed; boundary=\"$boundary\"\r\n";

    $message = "--$boundary\r\n";
    $message .= "Content-Type: text/html; charset=\"UTF-8\"\r\n";
    $message .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
    
    $message .= "
    <html>
    <body style='font-family: Arial, sans-serif; color: #333;'>
        <h2 style='color: #07162d;'>Nueva Información de Cliente para LocalWebPro</h2>
        <p>Has recibido nueva información de un cliente para la construcción de su página web.</p>
        
        <h3 style='color: #9e1428; border-bottom: 2px solid #9e1428; padding-bottom: 5px;'>Información Personal del Cliente</h3>
        <p><strong>Nombre Completo:</strong> $nombre_completo</p>
        <p><strong>Teléfono Personal:</strong> $telefono_personal</p>
        <p><strong>Email Personal:</strong> $email_personal</p>
        
        <h3 style='color: #9e1428; border-bottom: 2px solid #9e1428; padding-bottom: 5px;'>Información del Negocio</h3>
        <p><strong>Nombre del Negocio:</strong> $nombre_negocio</p>
        <p><strong>Teléfono del Negocio:</strong> $telefono_negocio</p>
        <p><strong>Email del Negocio:</strong> $email_negocio</p>
        
        <h4 style='color: #07162d;'>Servicios Principales:</h4>
        <pre style='background-color: #f5f5f5; padding: 10px; border-radius: 5px; white-space: pre-wrap;'>$servicios</pre>
        
        <h4 style='color: #07162d;'>Ciudades donde opera:</h4>
        <pre style='background-color: #f5f5f5; padding: 10px; border-radius: 5px; white-space: pre-wrap;'>$ciudades</pre>

        <p><em>Los archivos adjuntos (logotipo y fotos) se encuentran en este correo.</em></p>
    </body>
    </html>
    \r\n";
    
    foreach ($attachments as $file) {
        if (is_file($file)) {
            $message .= "--$boundary\r\n";
            $file_type = mime_content_type($file);
            $file_name = basename($file);
            $message .= "Content-Type: $file_type; name=\"$file_name\"\r\n";
            $message .= "Content-Disposition: attachment; filename=\"$file_name\"\r\n";
            $message .= "Content-Transfer-Encoding: base64\r\n\r\n";
            $message .= chunk_split(base64_encode(file_get_contents($file))) . "\r\n";
        }
    }
    
    $message .= "--$boundary--";

    if (mail($recipient_email, $email_subject, $message, $headers)) {
        header("Location: confirmacion-pago.php?status=success");
        exit();
    } else {
        echo "Hubo un error al enviar tu información. Por favor, inténtalo de nuevo.";
    }

} else {
    header("Location: formulario-informacion.php");
    exit();
}
?>