/**
 * -------------------------------------------
 * LÓGICA DEL CONTADOR PARA OFERTA PRINCIPAL
 * -------------------------------------------
 */
const setupMainOfferCountdown = () => {
    const countdownCard = document.getElementById('cta-timer-card');
    if (!countdownCard) return;

    // URL a la que se redirigirá cuando el tiempo se agote
    const expiredUrl = "/oferta.php";
    
    // Elementos del contador
    const dEl = document.getElementById('days');
    const hEl = document.getElementById('hours');
    const mEl = document.getElementById('minutes');
    const sEl = document.getElementById('seconds');
    
    if (!dEl || !hEl || !mEl || !sEl) {
        console.error("Error: Elementos del contador no encontrados.");
        return;
    }

    // Usamos una clave única en localStorage para este contador
    let savedDeadline = localStorage.getItem('mainOfferDeadline');
    
    if (!savedDeadline) {
        // Duración específica para la oferta principal
        const durationInMs = (3 * 24 * 60 * 60 * 1000) + // 3 Días
                             (3 * 60 * 60 * 1000)      + // 3 Horas
                             (33 * 60 * 1000)          + // 33 Minutos
                             (33 * 1000);                // 33 Segundos
        
        const newDeadline = new Date(Date.now() + durationInMs);
        savedDeadline = newDeadline.getTime();
        localStorage.setItem('mainOfferDeadline', savedDeadline);
    }

    const deadline = new Date(parseInt(savedDeadline));

    const updateTimer = () => {
        const diff = deadline - new Date();

        if (diff <= 0) {
            clearInterval(timerInterval);
            // Redirigir a la página de oferta expirada
            window.location.href = expiredUrl;
            return;
        }
        
        const days = Math.floor(diff / (1000 * 60 * 60 * 24));
        const hours = Math.floor((diff / (1000 * 60 * 60)) % 24);
        const minutes = Math.floor((diff / (1000 * 60)) % 60);
        const seconds = Math.floor((diff / 1000) % 60);

        dEl.textContent = String(days).padStart(2, '0');
        hEl.textContent = String(hours).padStart(2, '0');
        mEl.textContent = String(minutes).padStart(2, '0');
        sEl.textContent = String(seconds).padStart(2, '0');
    };

    if (deadline - new Date() <= 0) {
        window.location.href = expiredUrl;
        return;
    }

    updateTimer();  
    const timerInterval = setInterval(updateTimer, 1000);
};

// Asegúrate de llamar a esta función cuando se cargue la página
document.addEventListener('DOMContentLoaded', () => {
    setupMainOfferCountdown();
    // ... aquí llamas a las otras funciones de tu script (menú, etc.)
});