document.addEventListener('DOMContentLoaded', () => {

    /**
     * -------------------------------------------
     * LÓGICA DEL CONTADOR PARA OFERTA FLASH (CORREGIDO)
     * -------------------------------------------
     */
    const setupFlashOfferCountdown = () => {
        const countdownCard = document.getElementById('cta-timer-card');
        if (!countdownCard) return;

        // URL a la que se redirigirá cuando el tiempo se agote
        const expiredUrl = "/oferta-expirada"; // Usamos la URL limpia
        
        // Elementos del contador
        const hEl = document.getElementById('hours');
        const mEl = document.getElementById('minutes');
        const sEl = document.getElementById('seconds');
        
        // Si falta algún elemento, detenemos la ejecución para evitar errores
        if (!hEl || !mEl || !sEl) {
            console.error("Error: Faltan uno o más elementos del contador (hours, minutes, seconds).");
            return;
        }

        // Usamos una clave de localStorage para que el contador persista
        const storageKey = 'flashOfferDeadline';
        let savedDeadline = localStorage.getItem(storageKey);
        
        // Si no hay una fecha límite guardada, creamos una nueva de 24 horas
        if (!savedDeadline) {
            const durationInMs = 24 * 60 * 60 * 1000; // 24 Horas
            const newDeadline = Date.now() + durationInMs;
            savedDeadline = newDeadline.toString();
            localStorage.setItem(storageKey, savedDeadline);
        }

        const deadline = parseInt(savedDeadline);

        // Función que actualiza el contador visualmente
        const updateTimer = () => {
            const diff = deadline - Date.now();

            // Si el tiempo se acabó, redirigimos y detenemos todo
            if (diff <= 0) {
                clearInterval(timerInterval);
                window.location.href = expiredUrl;
                return;
            }
            
            // --- CÁLCULO SIMPLIFICADO Y CORRECTO ---
            const hours = Math.floor(diff / (1000 * 60 * 60));
            const minutes = Math.floor((diff / (1000 * 60)) % 60);
            const seconds = Math.floor((diff / 1000) % 60);

            // Actualizamos los números en la pantalla
            hEl.textContent = String(hours).padStart(2, '0');
            mEl.textContent = String(minutes).padStart(2, '0');
            sEl.textContent = String(seconds).padStart(2, '0');
        };

        // Verificamos una vez si ya expiró al cargar la página
        if (deadline <= Date.now()) {
            window.location.href = expiredUrl;
            return;
        }

        // Ejecutamos la función una vez al inicio y luego cada segundo
        updateTimer();  
        const timerInterval = setInterval(updateTimer, 1000);
    };

    // Llamamos a la función principal
    setupFlashOfferCountdown();

    // ... aquí puedes llamar a las otras funciones de tu script (menú, etc.)
});