<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <title>Oferta Finalizada | LocalWebPro</title>
    <meta name="description" content="La oferta especial para tu página web profesional ha finalizado. Únete a la lista de espera VIP para futuras oportunidades.">

    <?php require_once 'files/gtm_head.php'; ?>

    <link rel="icon" href="img/favicon.webp" sizes="any">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest" defer></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'brand-primary': '#07162d',
                        'brand-secondary': '#9e1428',
                        'brand-highlight': '#ffc857',
                        'brand-light-bg': '#f5f5f5',
                        'brand-white': '#f5f5f5',
                        'brand-dark-text': '#07080a',
                        'brand-light-text': '#f3f4f6',
                    },
                    fontFamily: { 'sans': ['Barlow', 'sans-serif'] }
                }
            }
        }
    </script>
    <link rel="stylesheet" href="style.css">
</head>
<body class="font-sans bg-brand-primary text-brand-light-text overflow-x-hidden">

<?php require_once 'files/gtm_body.php'; ?>

<div id="notification-container" class="fixed top-5 right-5 z-[100] p-4 rounded-lg shadow-lg text-white text-sm font-bold opacity-0 transition-all duration-300 pointer-events-none -translate-y-10">
    <span id="notification-message"></span>
</div>

<header class="bg-brand-primary absolute top-0 left-0 right-0 z-10">
    <div class="mx-auto max-w-7xl px-4 sm:px-6">
        <div class="h-16 md:h-20 flex items-center justify-center">
            <a href="/" aria-label="Ir a la página principal">
                <img src="img/OrozDesignMultimedia.webp" alt="Logo OrozDesign Multimedia" class="h-8 md:h-10 w-auto object-contain">
            </a>
        </div>
    </div>
</header>

<main>
    <section class="relative flex items-center justify-center min-h-screen text-white text-center p-6"
             style="background-image: radial-gradient(900px 420px at 50% 30%, rgba(255,200,87,.08), transparent 70%), linear-gradient(rgba(7,22,45,.92), rgba(7,22,45,.92)), url('img/BG01.webp'); background-size: cover; background-position: center;">
        
        <div class="relative z-10 max-w-3xl mx-auto">
            
            <div class="flex justify-center mb-6">
                <i data-lucide="lock-keyhole" class="w-16 h-16 text-brand-secondary"></i>
            </div>

            <p class="font-semibold uppercase tracking-widest text-brand-highlight">LA OPORTUNIDAD HA FINALIZADO</p>

            <h1 class="mt-4 font-black uppercase tracking-tight leading-[1.05] text-4xl sm:text-5xl text-white">
                Esta Puerta Se Ha Cerrado
            </h1>

            <p class="mt-5 text-lg text-white/80 max-w-2xl mx-auto">
                Tal como lo prometimos, el tiempo para acceder a esta oferta especial ha terminado. Para ser justos con quienes tomaron acción a tiempo, no podemos hacer excepciones.
            </p>

            <div class="mt-10 relative rounded-2xl shadow-2xl ring-2 ring-brand-secondary/60 p-[1px] bg-gradient-to-br from-brand-secondary/40 via-white/10 to-brand-secondary/20">
                <div class="relative rounded-2xl bg-[#0b1b33]/90 backdrop-blur-sm p-6 md:p-8">
                    <h2 class="font-black text-xl sm:text-2xl text-white uppercase inline-flex items-center gap-3">
                        <i data-lucide="mail-plus" class="w-7 h-7 text-brand-highlight"></i>
                        <span>No Cometas el Mismo Error Dos Veces</span>
                    </h2>
                    <p class="mt-2 text-white/80">Únete a la <strong>Lista de Espera VIP</strong> y serás el primero en saber si abrimos una nueva oportunidad.</p>
                    
                    <form id="waitlist-form" action="suscripcion.php" method="POST" class="mt-6 flex flex-col sm:flex-row gap-3 max-w-lg mx-auto">
                        <input 
                            type="email" 
                            name="email" 
                            placeholder="Tu mejor correo electrónico"
                            required
                            class="w-full px-5 py-3 rounded-lg bg-white/5 border-2 border-white/20 focus:border-brand-highlight focus:ring-brand-highlight transition text-white placeholder:text-white/50"
                        >
                        
                        <div style="position: absolute; left: -5000px;" aria-hidden="true">
                            <input type="text" name="user_comment" tabindex="-1" value="">
                        </div>

                        <button 
                            type="submit"
                            class="inline-flex items-center justify-center gap-2 w-full sm:w-auto px-6 py-3 text-base font-extrabold rounded-lg bg-brand-highlight text-brand-dark-text shadow-lg hover:opacity-90 transition">
                            <i data-lucide="mail-check" class="w-5 h-5"></i> NOTIFICARME
                        </button>
                    </form>
                    <div class="mt-3 flex flex-wrap items-center justify-center gap-x-4 gap-y-2 text-xs text-white/60">
                        <span class="inline-flex items-center gap-1.5">
                            <i data-lucide="shield-off" class="w-3 h-3"></i>
                            Cero Spam
                        </span>
                        <span class="hidden sm:inline">•</span>
                        <span class="inline-flex items-center gap-1.5">
                            <i data-lucide="shield-check" class="w-3 h-3"></i>
                            Tu Correo Está Seguro Con Nosotros
                        </span>
                    </div>
                </div>
            </div>

        </div>
    </section>
</main>

<?php require_once 'files/footer.php'; ?>


<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Activa los iconos de Lucide
        if (typeof lucide !== 'undefined') {
            lucide.createIcons();
        }
        
        // --- LÓGICA DEL FORMULARIO AJAX ---
        const form = document.getElementById('waitlist-form');
        if (form) {
            const notificationContainer = document.getElementById('notification-container');
            const notificationMessage = document.getElementById('notification-message');

            form.addEventListener('submit', function(event) {
                event.preventDefault();
                const formData = new FormData(form);
                const submitButton = form.querySelector('button[type="submit"]');
                const originalButtonHTML = submitButton.innerHTML;

                submitButton.disabled = true;
                submitButton.innerHTML = `<svg class="animate-spin h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>`;

                fetch(form.action, {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        notificationContainer.style.backgroundColor = '#10B981'; // Verde
                        form.reset();
                    } else {
                        notificationContainer.style.backgroundColor = '#EF4444'; // Rojo
                    }
                    notificationMessage.textContent = data.message;
                    notificationContainer.classList.remove('opacity-0', '-translate-y-10');
                    setTimeout(() => {
                        notificationContainer.classList.add('opacity-0', '-translate-y-10');
                    }, 5000);
                })
                .catch(error => {
                    notificationMessage.textContent = 'Error de conexión. Inténtalo de nuevo.';
                    notificationContainer.style.backgroundColor = '#EF4444';
                    notificationContainer.classList.remove('opacity-0', '-translate-y-10');
                    setTimeout(() => {
                        notificationContainer.classList.add('opacity-0', '-translate-y-10');
                    }, 5000);
                    console.error('Error:', error);
                })
                .finally(() => {
                    submitButton.disabled = false;
                    submitButton.innerHTML = originalButtonHTML;
                });
            });
        }
    });
</script>

</body>
</html>