<!DOCTYPE html>
<html lang="es">
<head>
        <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <title>Página Web Para Negocios Locales En Estados Unidos | LocalWebPro Por Solo $197</title>
    <meta name="description" content="Consigue una página web profesional en Estados Unidos diseñada para atraer clientes. Paquete todo incluido por $197 para dueños de negocios locales. ¡Garantía de Cero Riesgo!">
    
<?php require_once 'files/gtm_head.php'; ?>


    <link rel="icon" href="img/favicon.webp" sizes="any">
    <link rel="icon" href="favicon.webp" type="image/svg+xml">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.webp">

    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest" defer></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'brand-primary': '#07162d',
                        'brand-secondary': '#9e1428',
                        'brand-highlight': '#ffc857',
                        'brand-light-bg': '#f5f5f5',
                        'brand-white': '#FFFFFF',
                        'brand-dark-text': '#07080a',
                        'brand-light-text': '#f3f4f6',
                        'dark-red-bg': '#9e1428',
                        'dark-black-bg': '#07080a',
                    },
                    fontFamily: { 'sans': ['Barlow', 'sans-serif'] }
                }
            }
        }
    </script>

    <style>
        html { scroll-behavior: smooth; overflow-x: hidden; }
        body { -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; }
        .btn { display: inline-flex; align-items: center; justify-content: center; padding: 0.875rem 2rem; border-radius: 0.5rem; font-weight: 700; font-size: 1rem; text-transform: uppercase; transition: all 0.3s ease; gap: 0.75rem; box-shadow: 0 4px 14px 0 rgba(0,0,0,0.1); }
        .btn-highlight { background-color: #ffc857; color: #07080a; }
        .btn-highlight:hover { background-color: #e6b04e; transform: translateY(-3px); box-shadow: 0 7px 20px 0 rgba(0,0,0,0.15); }
        .btn-whatsapp { background-color: #25D366; color: #FFFFFF; }
        .btn-whatsapp:hover { background-color: #1DAE54; transform: translateY(-3px); box-shadow: 0 7px 20px 0 rgba(46, 204, 113, 0.25); }
    </style>
</head>
<body class="font-sans bg-brand-light-bg text-brand-dark-text overflow-x-hidden">

<?php require_once 'files/gtm_body.php'; ?>


    <header class="text-white text-center bg-brand-primary">
        <div class="container mx-auto max-w-4xl px-6 py-20 md:py-28">
            
            <a href="https://generamasclientes.com/" title="Volver A La Página Principal" class="block mb-8">
                <img src="img/OrozDesignMultimedia.webp"
                     alt="Logo OrozDesign Multimedia"
                     class="mx-auto h-16 md:h-20 w-auto"
                     onerror="this.onerror=null;this.src='https://placehold.co/250x80/07162d/ffc857?text=Logo';">
            </a>

            <div class="mx-auto mb-6 w-20 h-20 rounded-full bg-brand-highlight/10 flex items-center justify-center ring-4 ring-brand-highlight/90">
                <i data-lucide="check" class="w-12 h-12 text-brand-highlight"></i>
            </div>
            
            <h1 class="text-4xl sm:text-5xl md:text-6xl font-black uppercase leading-tight">
                ¡Gracias por tu Compra!
            </h1>

            <p class="mt-4 text-lg md:text-xl text-gray-300 max-w-3xl mx-auto">
                Hemos recibido tu pago y estamos listos para empezar a construir la herramienta que atraerá más clientes a tu negocio. ¡Felicidades por dar este paso!
            </p>
        </div>
    </header>

    <main>
        <section id="next-steps" class="py-16 md:py-24">
            <div class="container mx-auto max-w-5xl px-6">
                <div class="text-center max-w-3xl mx-auto">
                    <h2 class="text-3xl sm:text-4xl md:text-5xl font-black text-brand-primary uppercase">
                        Para empezar, solo necesitamos <span class="text-brand-secondary">dos cosas de ti:</span>
                    </h2>
                    <p class="mt-4 text-lg text-gray-600">
                        Completar estos dos sencillos pasos nos permitirá arrancar tu proyecto a la máxima velocidad.
                    </p>
                </div>

                <div class="mt-14 grid md:grid-cols-2 gap-8 items-stretch">
                    <div class="bg-white rounded-2xl shadow-xl p-8 flex flex-col ring-1 ring-gray-200 hover:-translate-y-1 transition-transform duration-300">
                        <div class="flex-shrink-0 flex items-center gap-4">
                            <span class="flex items-center justify-center h-12 w-12 rounded-full bg-brand-secondary text-white font-black text-2xl">1</span>
                            <h3 class="text-2xl font-black uppercase text-brand-primary">Envía la Información de tu Negocio</h3>
                        </div>
                        <p class="mt-4 text-gray-600 flex-grow">
                            Este es el paso clave. Para diseñar tu web, necesitamos conocer los detalles de tu negocio: servicios, contacto y clientes ideales.
                        </p>
                        <a href="formulario-informacion" target="_blank" class="btn btn-highlight mt-6 w-full">
                            <i data-lucide="file-text"></i>
                            Enviar Información del Negocio
                        </a>
                    </div>

                    <div class="bg-white rounded-2xl shadow-xl p-8 flex flex-col ring-1 ring-gray-200 hover:-translate-y-1 transition-transform duration-300">
                        <div class="flex-shrink-0 flex items-center gap-4">
                            <span class="flex items-center justify-center h-12 w-12 rounded-full bg-brand-secondary text-white font-black text-2xl">2</span>
                            <h3 class="text-2xl font-black uppercase text-brand-primary">Únete a Nuestro Grupo VIP</h3>
                        </div>
                        <p class="mt-4 text-gray-600 flex-grow">
                            Aquí recibirás soporte prioritario, conectarás con otros dueños de negocios y serás el primero en conocer nuestras nuevas herramientas y estrategias.
                        </p>
                        <a href="https://chat.whatsapp.com/invitation-link" target="_blank" class="btn btn-whatsapp mt-6 w-full">
                            <i class="ph-bold ph-whatsapp-logo" style="font-size: 1.5rem;"></i>
                            Unirme al Grupo VIP
                        </a>
                    </div>
                </div>
            </div>
        </section>

<section id="package-recap" class="py-16 md:py-24 bg-brand-primary text-white">
    <div class="container mx-auto max-w-7xl px-6 grid md:grid-cols-2 gap-12 md:gap-16 items-center">
        
        <div data-aos="fade-right">
            <img src="img/Paquete-Web.webp" 
                 alt="Paquete LocalWebPro">
        </div>

        <div data-aos="fade-left">
            <p class="font-bold text-brand-highlight uppercase tracking-widest">Tu compra incluye:</p>
            <h2 class="mt-2 text-3xl sm:text-4xl md:text-5xl font-black uppercase">
                Tu Kit de Crecimiento Digital, <span class="text-brand-highlight">Desbloqueado.</span>
            </h2>

            <ul class="mt-8 space-y-6">
                <li class="flex items-start gap-4">
                    <i data-lucide="monitor-smartphone" class="w-8 h-8 text-brand-highlight flex-shrink-0"></i>
                    <div>
                        <h4 class="font-bold text-xl">Página Web Profesional de Alto Impacto</h4>
                        <p class="text-gray-300">Un sitio diseñado para convertir visitantes en clientes y posicionarte como la mejor opción en tu área.</p>
                    </div>
                </li>
                <li class="flex items-start gap-4">
                    <i data-lucide="brain-circuit" class="w-8 h-8 text-brand-highlight flex-shrink-0"></i>
                    <div>
                        <h4 class="font-bold text-xl">Tu Propia Agencia de Marketing con IA</h4>
                        <p class="text-gray-300">6 herramientas de IA para crear planes, anuncios y cotizaciones, ahorrándote horas de trabajo.</p>
                    </div>
                </li>
                <li class="flex items-start gap-4">
                    <i data-lucide="graduation-cap" class="w-8 h-8 text-brand-highlight flex-shrink-0"></i>
                    <div>
                        <h4 class="font-bold text-xl">Curso Exclusivo: Domina el Marketing</h4>
                        <p class="text-gray-300">El conocimiento para usar tus nuevas herramientas y crear estrategias que realmente funcionan.</p>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</section>

    </main>
    
<?php require_once 'files/footer.php'; ?>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
            const yearEl = document.getElementById('year');
            if (yearEl) {
                yearEl.textContent = new Date().getFullYear();
            }
        });
    </script>
</body>
</html>