<?php
header('Content-Type: application/json');

$response = array('success' => false, 'message' => '');

// Dirección de correo a la que se enviará el formulario. ¡Cámbiala a la tuya!
$recipient = "orozdesign@gmail.com"; 

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Recopilar y sanear los datos del formulario
    $name = trim(filter_input(INPUT_POST, 'name', FILTER_SANITIZE_FULL_SPECIAL_CHARS));
    $email = trim(filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL));
    $phone = trim(filter_input(INPUT_POST, 'phone', FILTER_SANITIZE_FULL_SPECIAL_CHARS));
    $service = trim(filter_input(INPUT_POST, 'service', FILTER_SANITIZE_FULL_SPECIAL_CHARS));
    $message = trim(filter_input(INPUT_POST, 'message', FILTER_SANITIZE_FULL_SPECIAL_CHARS));

    // --- BLOQUE DE LÓGICA ANTI-SPAM ---

    // 1. Validar el formato de teléfono de EE. UU. (10 dígitos)
    $is_valid_phone = preg_match('/^\d{10}$/', str_replace(['(', ')', '-', ' '], '', $phone));

    // 2. Detectar enlaces en el mensaje
    $has_links = preg_match('/https?:\/\/[^\s]+/i', $message);

    // 3. Bloquear palabras clave de marketing (en minúsculas para una detección más amplia)
    $blocked_keywords = [
        'collaboration', 'affiliates', 'payouts', 'monkey digital',
        'seo', 'sem', 'google ads', 'meta ads', 'marketing digital', 'digital marketing',
        'publicidad', 'posicionamiento web', 'estrategia', 'marketing', 'online marketing',
        // Puedes agregar más palabras clave aquí
    ];
    
    $is_spam_keyword = false;
    foreach ($blocked_keywords as $keyword) {
        if (stripos($message, $keyword) !== false || stripos($name, $keyword) !== false) {
            $is_spam_keyword = true;
            break;
        }
    }

    // 4. Bloquear cualquier idioma que no sea inglés o español
    // Este filtro es muy estricto. Usa una expresión regular para permitir solo
    // caracteres alfabéticos en inglés/español, números, y signos de puntuación comunes.
    // Esto podría bloquear mensajes legítimos con caracteres especiales no contemplados.
    $is_english_or_spanish = preg_match('/^[a-zA-Z0-9\s.,;?¿¡!ñÑáéíóúÁÉÍÓÚüÜ@()\-+]*$/u', $message);
    $is_valid_name = preg_match('/^[a-zA-Z\sñÑáéíóúÁÉÍÓÚüÜ]*$/u', $name);

    // --- FIN DEL BLOQUE ANTI-SPAM ---

    // 5. Validar los datos esenciales y aplicar las reglas de bloqueo
    $is_spam = !$is_valid_phone || $has_links || $is_spam_keyword || !$is_english_or_spanish || !$is_valid_name;

    if ($is_spam) {
        // Si se detecta como spam, se envía una respuesta de éxito falsa
        $response['success'] = true;
        $response['message'] = '¡Tu mensaje ha sido enviado! Lo revisaremos pronto.';
    } elseif (empty($name) || empty($email) || empty($phone) || empty($service) || empty($message) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // En caso de que un usuario real olvide llenar un campo, también se le da un mensaje falso de éxito para evitar dar pistas.
        $response['success'] = true;
        $response['message'] = '¡Cotización enviada con éxito! Nos pondremos en contacto pronto.';
    } else {
        // Si todo está correcto y no es spam, envía el correo real
        $email_subject = "Nueva Solicitud de Cotización de: $name";
        $email_content = "Nombre: $name\n";
        $email_content .= "Correo Electrónico: $email\n";
        $email_content .= "Teléfono: $phone\n";
        $email_content .= "Servicio Solicitado: $service\n";
        $email_content .= "Mensaje:\n$message\n";
        
        $email_headers = "From: " . $name . " <" . $email . ">\r\n";
        $email_headers .= "Reply-To: " . $email . "\r\n";
        $email_headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $email_headers .= "X-Mailer: PHP/" . phpversion();

        if (@mail($recipient, $email_subject, $email_content, $email_headers)) {
            $response['success'] = true;
            $response['message'] = '¡Cotización enviada con éxito! Nos pondremos en contacto pronto.';
        } else {
            // Este es un mensaje de error real si el servidor de correo falla.
            $response['message'] = 'Hubo un problema al enviar tu cotización. Por favor, inténtalo de nuevo más tarde.';
        }
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

echo json_encode($response);
?>